<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "../gUtil/GestoreUpload.php";
    include "../classi/Cartella.php";
    
    include "include/controlloLogin.php";
    
    $datiCartellaRadice = $geecomDb->leggiSingolaRiga("geecD_cartelleRadice",$_SESSION["geecomAdmin_id"],"idUtente");
    
    $cartellaRadice = new Cartella($geecomDb, $datiCartellaRadice["idCartella"]);
    $cartellaRadice->caricaDatiDalDatabase();
    
    $impostazioni = recuperaImpostazioni($geecomDb);
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
    <title>Geecom Doc - area amministrativa</title>

  </head>
  <body>
    
    <header>
        <?php 
            include "include/barraSuperiore.php";
            
            include "include/header.php";
            
            include "include/barraMenu.php";
        ?>
    </header>
	  
    <main role="main" class="bg-light" id="main">
        <div id="dashboard" class="container-fluid">
            <div class="row">
                <!-- Colonna principale -->
                <div class="col-12 py-4">
                    <div class="form-row">
                        <div class="col-md-4 col-lg-3 sticky-top-md align-self-start">
                            <h5 class="mb-3"><i class="far fa-hdd mr-2"></i>Spazio occupato</h5>
                            <div class="card card-body border-0 mb-4">
                                <?php
                                    $spazioOccupato = calocloSpazioOccupato($geecomDb);
                                    
                                    if(!is_numeric($spazioOccupato)) {
                                        $spazioOccupato = 0;
                                    } 
                                    
                                    $valore1PerCento = $impostazioni["spazioSuDiscoDaOccupareInMb"] / 100;
                                    
                                    if($spazioOccupato<$valore1PerCento/2) {
                                        $percentualeSpazioOccupato = 0;
                                    }
                                    else if($spazioOccupato<=$valore1PerCento) {
                                        $percentualeSpazioOccupato = 1;
                                    }
                                    else {
                                        $percentualeSpazioOccupato =  round($spazioOccupato / $impostazioni["spazioSuDiscoDaOccupareInMb"] * 100,2);
                                    }
                                    
                                    if($percentualeSpazioOccupato>85) {
                                        $classeAggiuntivaBarra = "bg-danger";
                                    }
                                    else if($percentualeSpazioOccupato>65) {
                                        $classeAggiuntivaBarra = "bg-warning";
                                    }
                                    else {
                                        $classeAggiuntivaBarra = "";
                                    }
                                ?>
                                <div class="progress mb-2">
                                    <div class="progress-bar <?= $classeAggiuntivaBarra ?>" role="progressbar" style="width: <?php echo $percentualeSpazioOccupato ?>%;" aria-valuenow="<?php echo $percentualeSpazioOccupato ?>" aria-valuemin="0" aria-valuemax="100"><?php echo $percentualeSpazioOccupato ?>%</div>
                                </div>
                                <small ><?php echo $spazioOccupato ?> Mb occupati su <?php echo $impostazioni["spazioSuDiscoDaOccupareInMb"] ?> Mb disponibili</small> 
                            </div>
                        </div>
                        <div class="col-md-8 col-lg-9 file-manager">
                            <h5 class="mb-3"><i class="far fa-star mr-2"></i>Cartelle preferite</h5>
                            <div class="card card-body border-0 mb-4">
                                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 row-cols-xl-4" id="cartellePreferite">
                                    <?php 
                                        $query       = "SELECT c.* FROM geecD_cartellePreferite AS cp JOIN geecD_cartelle AS c ON cp.idCartella = c.id WHERE idUtente = {$_SESSION["geecomAdmin_id"]}";
                                        $risCartelle = $geecomDb->eseguiQueryLettura($query);

                                        while($cartellaPreferita = $risCartelle->fetch_assoc()) {
                                            stampaCartella($geecomDb, $cartellaPreferita,true,true);
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-4 col-lg-3 sticky-top-md align-self-start">
                                <form class="mb-3">
                                    <div class="input-group">
                                        <input type="text" class="d-none" id="campoInputCartellaMadre2" value="1">
                                        <input type="text" class="form-control" id="campoCreaCartella2" aria-label="Text input with segmented dropdown button">
                                        <div class="input-group-append">
                                            <button class="btn btn-primary" type="button" onclick="creaCartella('campoCreaCartella2','campoInputCartellaMadre2')"><span class="d-none d-xl-inline-block mr-2">Nuova cartella</span><i class="fas fa-folder-plus"></i></button>
                                        </div>
                                    </div>
                                </form>
                                <div class="card card-body border-0 mb-4 albero-cartelle" id="divAlberoCartella">
                                    <?php
                                        $cartellaRadice->alberoCartella();
                                        
                                        if($_SESSION["geecomAdmin_ruolo"]=="super admin") {
                                            $cartellaRadice->alberoCartellaTemplate("","collapse show");
                                        }
                                    ?>	
                                </div>
                        </div>
                        <div class="col-md-8 col-lg-9 file-manager">
                            <div class="card card-body border-0">
                                <div class="d-xl-flex justify-content-between align-items-center">
                                    <?php 
                                        $cartellaRadice->stampaBreadcrumbCartella($cartellaRadice->getId());
                                    ?>
                                    <div class="d-sm-flex align-items-center justify-content-between">
                                        <form action="ricercaFileSystem.php" name="formRicerca">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="cerca" id="cerca" placeholder="Cerca qualcosa..." aria-label="Text input with segmented dropdown button">
                                                <select class="form-control" name="tipoRicerca" id="tipoRicerca">
                                                    <option value="Questa cartella">Questa cartella</option>
                                                    <option value="Tutte le cartelle">Tutte le cartelle</option>
                                                </select>
                                                <div class="input-group-append">
                                                    <button class="btn btn-primary" type="button" onclick="eseguiRicerca()"><i class="fas fa-search"></i></button>
                                                </div>
                                            </div>
                                        </form>
                                        
                                        <div class="d-flex ml-2">
                                            <div class="dropdown my-2 my-lg-0 mr-2">
                                                <a class="dropdown-toggle ml-lg-3" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fas fa-cog"></i>
                                                </a>

                                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
                                                    <a class="dropdown-item" href="#" onclick="apriPopupSpostaElementiSelezionati()"><i class="fas fa-arrow-right mr-2"></i>Sposta selezionati</a>
                                                    <a class="dropdown-item text-danger" href="#" onclick="apriPopupEliminaElementiSelezionati()"><i class="far fa-trash-alt mr-2"></i>Elimina selezionati</a>
                                                    <div class="dropdown-divider"></div>
                                                    <a class="dropdown-item text-danger" href="#" data-toggle="modal" data-target="#modalEliminaContenutoCartella"><i class="far fa-trash-alt mr-2"></i>Elimina tutti</a>
                                                </div>
                                            </div>

                                            <div class="dropdown my-2 my-lg-0 ">
                                                <a class="dropdown-toggle ml-lg-3" href="#" role="button" id="dropdownOrderLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fas fa-sort"></i>
                                                </a>

                                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownOrderLink">
                                                    <a class="dropdown-item" href="#" onclick="apriPopupSpostaElementiSelezionati()"><i class="fas fa-sort-alpha-up mr-2"></i>A - Z</a>
                                                    <a class="dropdown-item" href="#" onclick="apriPopupEliminaElementiSelezionati()"><i class="fas fa-sort-alpha-down mr-2"></i>Z - A</a>
                                                    <a class="dropdown-item" href="#" onclick="apriPopupEliminaElementiSelezionati()"><i class="fas fa-history fa-flip-horizontal mr-2"></i>Più recenti</a>
                                                    <a class="dropdown-item" href="#" onclick="apriPopupEliminaElementiSelezionati()"><i class="fas fa-history mr-2"></i>Meno recenti</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                
                                <form action="../controller/controllerDocumenti.php" id="frmFileUpload-00" class="dropzone singolo-file mb-3" method="post" enctype="multipart/form-data">
                                    <div class="dz-message">
                                        <i class="fas fa-file-upload fa-2x mb-2"></i>
                                        <h5>Trascina o carica qui i file</h5>
                                    </div>
                                    <div class="fallback">
                                        <input name="file" type="file" />
                                    </div>
                                </form>

                                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 row-cols-xl-4" id="divContenutoCartella">
                                    <?php 
                                        $cartellaRadice->stampaContenutoCartella(true);
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Colonna principale -->
            </div>
        </div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/eliminaCartella.php";
        
        include "include/modal/eliminaContenutoCartella.php";
        
        include "include/modal/eliminaElementiSelezionati.php";
                
        include "include/modal/rinominaElemento.php";
                
        include "include/modal/eliminaDocumento.php";
        
        include "include/modal/condividiDocumento.php";
                
        include "include/modal/spostaElemento.php";
                
        include "include/modal/spostaElementiSelezionati.php";
        
        include "include/modal/modalMenuComponenti.php";

        include "include/modal/modalCreaPaginaCondivisione.php";
                
        include "include/modal/modalCreaPaginaApprovazione.php";

        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>
        <script>
            
            function aggiornaContenutoCartella(cerca) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCartelle.php",
                    data:{
                        operazione:"stampaContenutoCartella",
                        cerca:cerca,
                        id:<?= $cartellaRadice->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("divContenutoCartella").innerHTML = codice;
                        aggiornaElencoCartellePreferite(); // in home page questa funzione aggiorna anche le cartelle preferite
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function aggiornaElencoCartellePreferite() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCartelle.php",
                    data:{
                        operazione:"stampaCartellePreferite",
                    },
                    success:function(codice) {
                        document.getElementById("cartellePreferite").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function aggiornaAlberoCartella() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCartelle.php",
                    data:{
                        operazione:"stampaAlberoCartella",
                        id:<?php echo $cartellaRadice->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("divAlberoCartella").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
        </script>
        
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            $(".singolo-file").dropzone({
                acceptedFiles: ".pdf,.doc,.docx,.odt,.ppt,.pptx,.odp,.xls,.xlsx,.ods,.jpeg,.jpg,.png,.gif,.svg,.mp3,.mp4,.zip,.p7m",
                maxFiles: 10,
                parallelsuploads:10,
                uploadMultiple:true,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                maxFilesize:<?= $impostazioni["dimensioneMassimaFileInMb"] ?>,
                success: function(file,response) {
                    if(response=="ok") {
                        aggiornaContenutoCartella("");
                        this.removeAllFiles();
                    }
                    else {
                        alert(response);
                    }
                },
                params:{
                    operazione:"crea",
                    idCartella:1
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });  	
        </script>
  </body>
</html>